<?php

$apikey = $_POST['apikey'] ?? '';
$recognition_id = $_POST['recognition_id'] ?? '';



function callVisionApi($apikey, $method, $params = []){
    $url = 'https://vision.imstocker.com/api/v1/' . $method;
    $is_get = $method === 'getLimits';
    $is_file = $method === 'recognizeFile';

    if ($is_get && $params){
        $url = $url . '?' . http_build_query($params);
    }
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $headers = [
        "Authorization: Bearer $apikey",
        "Accept: application/json"
    ];
    if (!$is_get){
        if ($is_file){
            $headers[] = 'Content-Type: multipart/form-data';
        }
        else {
            $headers[] = 'Content-Type: application/json';
        }
    }
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    if (!$is_get){
        curl_setopt($curl, CURLOPT_POST, true);
        $content = $params;
        if (!$is_file){
            $content = json_encode($params);
        }
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
    }
    
    $result = curl_exec($curl);
    if ($result === false) {
        throw new Error('Failed to execute request ' . $method);
    }

    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    if ($status !== 200 && $status !== 201) {
        throw new Error('Api error: ' . $result);
    }

    return json_decode($result, true);
}

if (!empty($_POST['recognize']) && !empty($_FILES['file'])){
    $res = callVisionApi($apikey, 'recognizeFile', [
        'file' => new \CURLFile($_FILES['file']['tmp_name'], $_FILES['file']['type'], $_FILES['file']['name']),
        'negativePrompt' => $_POST['negative_prompt'] ?? '',
        'skipKeywords' => $_POST['skip_keywords'] ?? '',
        'count' => $_POST['count'] ?? '',
    ]);
    $recognition_id = $res['recognitionId'];
    
    echo "<h2>Response:</h2>";
    echo "<table width='100%'>
            <tr><td style='width:150px'>Recognition id:</td><td>" . htmlspecialchars($recognition_id) ."</td></tr>
            <tr><td style='width:150px'>Preview:</td><td><img width='100' src='data:image/jpeg;base64," . htmlspecialchars($res['preview']) . "'></td></tr>
            <tr><td style='width:150px'>Keywords:</td><td>" . htmlspecialchars(join(',', array_map(function($k){ return $k['title_keyword']; }, $res['keywords']))). "</td></tr>
            <tr><td style='width:150px'>Total left:</td><td>" . htmlspecialchars($res['limits']['totalLeft']). "</td></tr>
            <tr><td style='width:150px'>Raw result:</td><td><textarea style='width:100%'>" . htmlspecialchars(json_encode($res)). "</textarea></td></tr>
          </table>";
}
else if (!empty($_POST['update'])){
    $res = callVisionApi($apikey, 'updateKeywords', [
        'recognitionId' => (int)$recognition_id,
        'positiveKeywords' => !empty($_POST['positive_keywords']) ? explode(',', $_POST['positive_keywords']) : [],
        'negativeKeywords' => !empty($_POST['negative_keywords']) ? explode(',', $_POST['negative_keywords']) : [],
        'currentKeywords' => !empty($_POST['current_keywords']) ? explode(',', $_POST['current_keywords']) : [],
        'skipKeywords' => !empty($_POST['skip_keywords']) ? explode(',', $_POST['skip_keywords']) : [],
        'count' => !empty($_POST['count']) ? (int)$_POST['count'] : null,
    ]);    
    echo "<h2>Response:</h2>";
    echo "<table width='100%'>
            <tr><td style='width:150px'>Keywords:</td><td>" . htmlspecialchars(join(',', array_map(function($k){ return $k['title_keyword']; }, $res['keywords']))). "</td></tr>
            <tr><td style='width:150px'>Raw result:</td><td><textarea style='width:100%'>" . htmlspecialchars(json_encode($res)). "</textarea></td></tr>
          </table>"; 
}


?>
<h2>Recognize file</h2>
<form action="" method="POST" enctype="multipart/form-data">
    <table style="width: 100%">
        <tr>
            <td style='width:150px'><b>Api key*</b>:</td>
            <td><input style="width:100%" type="text" name="apikey" required value="<?php echo htmlspecialchars($apikey); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'><b>File*</b>:</td>
            <td><input type="file" name="file" accept="image/jpeg" required></td>
        </tr>
        <tr>
            <td style='width:150px'>Negative prompt:</td>
            <td><input style="width:100%" type="text" name="negative_prompt" value="<?php echo htmlspecialchars($_POST['negative_prompt'] ?? ''); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'>Skip keywords:</td>
            <td><input style="width:100%" type="text" name="skip_keywords" value="<?php echo htmlspecialchars($_POST['skip_keywords'] ?? ''); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'>Count:</td>
            <td><input style="width:100%" type="text" name="count"></td>
        </tr>
    </table>
    <button type="submit" name="recognize" value="1">Send</button>
</form>

<h2>Update keywords</h2>
<form action="" method="POST" enctype="multipart/form-data">
    <table style="width: 100%">
        <tr>
            <td style='width:150px'><b>Api key*</b>:</td>
            <td><input style="width:100%" type="text" name="apikey" required value="<?php echo htmlspecialchars($apikey); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'><b>Recognition Id*</b>:</td>
            <td><input style="width:100%" type="text" name="recognition_id" required value="<?php echo htmlspecialchars($recognition_id); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'>Positive keywords:</td>
            <td><input style="width:100%" type="text" name="positive_keywords" value="<?php echo htmlspecialchars($_POST['positive_keywords'] ?? ''); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'>Negative keywords:</td>
            <td><input style="width:100%" type="text" name="negative_keywords" value="<?php echo htmlspecialchars($_POST['negative_keywords'] ?? ''); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'>Current keywords:</td>
            <td><input style="width:100%" type="text" name="current_keywords" value="<?php echo htmlspecialchars($_POST['current_keywords'] ?? ''); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'>Skip keywords:</td>
            <td><input style="width:100%" type="text" name="skip_keywords" value="<?php echo htmlspecialchars($_POST['skip_keywords'] ?? ''); ?>"></td>
        </tr>
        <tr>
            <td style='width:150px'>Count:</td>
            <td><input style="width:100%" type="text" name="count"></td>
        </tr>
    </table>
    <button type="submit" name="update" value="1">Send</button>
</form>
